<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */
namespace Mageants\SimpleConfigurable\Block\Product\View;

use Magento\Framework\View\Element\Template;
use Magento\Framework\View\Element\Template\Context;
use Magento\Framework\Registry;
use Magento\Framework\Serialize\Serializer\Json;
use Magento\Catalog\Model\Product;
use Magento\Swatches\Helper\Data as SwatchHelper;
use Magento\Eav\Model\Config as EavConfig;

class ChildData extends Template
{
    /**
     * @var Registry
     */
    protected $coreRegistry;

    /**
     * @var Json
     */
    protected $jsonSerializer;

    /**
     * @var SwatchHelper
     */
    protected $swatchHelper;

    /**
     * @var EavConfig
     */
    protected $eavConfig;

    /**
     * @param Context $context
     * @param Registry $registry
     * @param Json $jsonSerializer
     * @param SwatchHelper $swatchHelper
     * @param EavConfig $eavConfig
     * @param array $data
     */
    public function __construct(
        Context $context,
        Registry $registry,
        Json $jsonSerializer,
        SwatchHelper $swatchHelper,
        EavConfig $eavConfig,
        array $data = []
    ) {
        $this->coreRegistry = $registry;
        $this->jsonSerializer = $jsonSerializer;
        $this->swatchHelper = $swatchHelper;
        $this->eavConfig = $eavConfig;
        parent::__construct($context, $data);
    }

    /**
     * Get current product
     *
     * @return Product|null
     */
    public function getProduct()
    {
        return $this->coreRegistry->registry('product');
    }

    /**
     * Get scp child product
     *
     * @return Product|null
     */
    public function getScpChildProduct()
    {
        return $this->coreRegistry->registry('mageants_scp_child_product');
    }

    /**
     * Get Child product Option Id
     *
     * @param object $childProduct
     * @return void
     */
    public function getChildOptionId($childProduct)
    {
        $optionDataSet = $this->getProduct()->getTypeInstance()->getConfigurableOptions($this->getProduct());
    
        $swatchAttributeData = [];
        $attributeData = [];
        $isSwatch = false;
    
        if (!empty($optionDataSet)) {
            foreach ($optionDataSet as $attId => $attributeOptions) {
                foreach ($attributeOptions as $option) {
                    $attributeCode = $option['attribute_code'];
    
                    // Get value from child product
                    $value = $childProduct->getData($attributeCode);
    
                    if ($value !== null) {
                        $swatchAttributeData[$attributeCode] = $value;
                        $attributeData['id_'.$attId] = $value;

                        // Check if attribute has swatch
                        $attribute = $this->eavConfig->getAttribute(Product::ENTITY, $attributeCode);
                        if ($this->swatchHelper->isVisualSwatch($attribute) ||
                            $this->swatchHelper->isTextSwatch($attribute)) {
                            $isSwatch = true;
                        }
                    }
    
                    // Only need the first option to get the attribute code
                    break;
                }
            }
        }
    
        return $isSwatch ? $swatchAttributeData : $attributeData;
    }

    /**
     * Get Serialized Child Option Id
     *
     * @param object $childProduct
     * @return void
     */
    public function getSerializedChildOptionId($childProduct)
    {
        return $this->jsonSerializer->serialize($this->getChildOptionId($childProduct));
    }
}
