<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */

namespace Mageants\SimpleConfigurable\Observer;

use Magento\Catalog\Model\Product;
use Magento\Customer\Model\Session;

class ChangeMeta implements \Magento\Framework\Event\ObserverInterface
{
    /**
     * @var \Magento\Customer\Model\Session
     */
    protected $session;

    /**
     * @var \Magento\Catalog\Model\Product
     */
    protected $simpleProduct;

    /**
     * @param \Magento\Customer\Model\Session $session
     * @param \Magento\Catalog\Model\Product $simpleProduct
     */
    public function __construct(
        \Magento\Customer\Model\Session $session,
        \Magento\Catalog\Model\Product $simpleProduct
    ) {
        $this->session = $session;
        $this->simpleProduct = $simpleProduct;
    }

    /**
     * @inheritdoc
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        if ($product = $observer->getEvent()->getProduct()) {
            if ($this->session->getCustomProductId() && $this->session->getCustomProductId() != '') {
                $product->setMetaTitle($this->simpleProduct->getMetaTitle());
                $product->setMetaKeyword($this->simpleProduct->getMetaKeyword());
                $product->setMetaDescription($this->simpleProduct->getMetaDescription());
            }
        }
    }
}
