<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */

namespace Mageants\SimpleConfigurable\Plugin\Catalog\Pricing\Render;

use Magento\Catalog\Pricing\Render\FinalPriceBox;

class FinalPriceBoxPlugin
{
    /**
     * After plugin for FinalPriceBox::_toHtml()
     *
     * @param FinalPriceBox $subject
     * @param string $result
     * @return string
     */
    public function afterToHtml(FinalPriceBox $subject, $result)
    {
        $result = str_replace(__('As low as'), '', $result);

        return $result;
    }
}
