<?php
/**
 * @category Mageants SimpleConfigurable
 * @package Mageants_SimpleConfigurable
 * @copyright Copyright (c) 2017 Mageants
 * @author Mageants Team <info@mageants.com>
 */

declare(strict_types=1);

namespace Mageants\SimpleConfigurable\Helper\Product\Options;

use Magento\Catalog\Api\Data\ProductInterface;
use Magento\ConfigurableProduct\Api\Data\OptionValueInterface;
use Magento\ConfigurableProduct\Api\Data\OptionValueInterfaceFactory;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable;
use Magento\Framework\Api\ExtensionAttribute\JoinProcessorInterface;
use Mageants\SimpleConfigurable\Helper\Data;

class Loader extends \Magento\ConfigurableProduct\Helper\Product\Options\Loader
{
    /**
     * @var JoinProcessorInterface
     */
    protected $extensionAttributesJoinProcessor;

    /**
     * @var OptionValueInterfaceFactory
     */
    protected $optionValueFactory;

    /**
     * @var Configurable
     */
    protected $configurable;

    /**
     * @var Data
     */
    protected $simpleConfigurableHelper;

    /**
     * Loader constructor.
     * @param OptionValueInterfaceFactory $optionValueFactory
     * @param JoinProcessorInterface $extensionAttributesJoinProcessor
     * @param Configurable $configurable
     * @param Data $simpleConfigurableHelper
     */
    public function __construct(
        OptionValueInterfaceFactory $optionValueFactory,
        JoinProcessorInterface $extensionAttributesJoinProcessor,
        Configurable $configurable,
        Data $simpleConfigurableHelper
    ) {
        parent::__construct(
            $optionValueFactory,
            $extensionAttributesJoinProcessor
        );
        $this->optionValueFactory = $optionValueFactory;
        $this->extensionAttributesJoinProcessor = $extensionAttributesJoinProcessor;
        $this->configurable = $configurable;
        $this->simpleConfigurableHelper = $simpleConfigurableHelper;
    }

    /**
     * Check is enable
     *
     * @return boolean
     */
    public function isScpEnable()
    {
        return $this->simpleConfigurableHelper->isEnable();
    }

    /**
     * Update page url
     *
     * @return boolean
     */
    public function updateScpPageUrl()
    {
        return $this->simpleConfigurableHelper->replaceUrl();
    }

    /**
     * @param ProductInterface $product
     * @return OptionInterface[]
     */
    public function load(ProductInterface $product)
    {
        $enable = $this->isScpEnable();
        $updatePageUrl = $this->updateScpPageUrl();
        if ($updatePageUrl && $enable) {
            $options = [];
            $attributeCollection = $this->configurable->getConfigurableAttributeCollection($product);
            $this->extensionAttributesJoinProcessor->process($attributeCollection);
            foreach ($attributeCollection as $attribute) {
                $values = [];
                $attributeOptions = $attribute->getOptions();
                if (is_array($attributeOptions)) {
                    foreach ($attributeOptions as $option) {
                        /** @var OptionValueInterface $value */
                        $value = $this->optionValueFactory->create();
                        $value->setValueIndex($option['value_index']);
                        $values[] = $value;
                    }
                }
                $attribute->setValues($values);
                $options[] = $attribute;
            }

            return $options;
        } else {
            return parent::load($product);
        }
    }
}
