<?php
namespace Banyo\BlogCustom\Helper;

use Magento\Framework\App\Helper\Context;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\View\Design\Theme\ThemeProviderInterface;

class Data extends \Mageplaza\Blog\Helper\Data
{
    /**
     * @var State
     */
    protected $appState;

    /**
     * @var ThemeProviderInterface
     */
    protected $themeProvider;

    /**
     * @param Context $context
     * @param ObjectManagerInterface $objectManager
     * @param StoreManagerInterface $storeManager
     * @param State $appState
     * @param ThemeProviderInterface $themeProvider
     * @param \Mageplaza\Blog\Model\PostFactory $postFactory
     */
    public function __construct(
        Context $context,
        ObjectManagerInterface $objectManager,
        StoreManagerInterface $storeManager,
        State $appState,
        ThemeProviderInterface $themeProvider,
        \Mageplaza\Blog\Model\PostFactory $postFactory,
        \Mageplaza\Blog\Model\CategoryFactory $categoryFactory,
        \Mageplaza\Blog\Model\TagFactory $tagFactory,
        \Mageplaza\Blog\Model\TopicFactory $topicFactory,
        \Mageplaza\Blog\Model\AuthorFactory $authorFactory,
        \Mageplaza\Blog\Model\PostHistoryFactory $postHistoryFactory,
        \Magento\Framework\Filter\TranslitUrl $translitUrl,
        \Magento\Framework\App\ProductMetadataInterface $productMetadata,
        \Magento\Customer\Model\Session $customerSession,
        \Magento\Framework\App\Http\Context $httpContext,
        \Magento\Framework\Stdlib\DateTime\DateTime $dateTime
    ) {
        $this->appState = $appState;
        $this->themeProvider = $themeProvider;

        parent::__construct(
            $context,
            $objectManager,
            $storeManager,
            $postFactory,
            $categoryFactory,
            $tagFactory,
            $topicFactory,
            $authorFactory,
            $postHistoryFactory,
            $translitUrl,
            $productMetadata,
            $customerSession,
            $httpContext,
            $dateTime
        );
    }


    /**
     * @param null $urlKey
     * @param null $type
     * @param null $store
     *
     * @return string
     */
    public function getBlogUrl($urlKey = null, $type = null, $store = null)
    {
        if (is_object($urlKey)) {
            $urlKey = $urlKey->getUrlKey();
        }

        $route = $this->getRoute($store);

        // ✅ Skip "post/" only if route = article and type = post
        if ($type === self::TYPE_POST && $route === 'article') {
            // leave $urlKey unchanged
        } else {
            $urlKey = ($type ? $type . '/' : '') . $urlKey;
        }

        $url = $this->getUrl($route . '/' . $urlKey);
        $url = explode('?', $url ?? '')[0];

        return rtrim($url, '/') . $this->getUrlSuffix($store);
    }
}
