<?php
namespace Banyo\BrandUrlCustomizer\Plugin;

use Mirasvit\Brand\Service\BrandUrlService;
use Mirasvit\Brand\Api\Data\BrandInterface;

/**
 * Plugin to modify brand URLs
 */
class BrandUrlServicePlugin
{
    /**
     * Modify the brand URL to use /brands/ instead of /brand/
     *
     * @param BrandUrlService $subject
     * @param string $result
     * @param BrandInterface $brand
     * @param int|null $storeId
     * @return string
     */
    public function afterGetBrandUrl(
        BrandUrlService $subject,
        string $result,
        BrandInterface $brand,
        ?int $storeId = null
    ): string {
        // Replace /brand/ with /brands/ in the URL
        $result = str_replace('/brand/', '/brands/', $result);

        // Ensure the URL ends with .html
        if (strpos($result, '.html') === false) {
            $result .= '.html';
        }

        return $result;
    }
}
