<?php

namespace Banyo\CustomCategory\Setup\Patch\Data;

use Magento\Catalog\Setup\CategorySetup;
use Magento\Catalog\Setup\CategorySetupFactory;
use Magento\Catalog\Setup\Patch\Data\UpdateMediaAttributesBackendTypes;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;
use Magento\Framework\Setup\Patch\PatchVersionInterface;
class AddBottomCategoryContent implements DataPatchInterface, PatchVersionInterface
{
    /**
     * @var ModuleDataSetupInterface
     */
    private $moduleDataSetup;

    /**
     * @var CategorySetupFactory
     */
    private $categorySetupFactory;

    /**
     * PatchInitial constructor.
     * @param ModuleDataSetupInterface $moduleDataSetup
     * @param CategorySetupFactory $categorySetupFactory
     */
    public function __construct(
        ModuleDataSetupInterface $moduleDataSetup,
        CategorySetupFactory $categorySetupFactory
    ) {
        $this->moduleDataSetup = $moduleDataSetup;
        $this->categorySetupFactory = $categorySetupFactory;
    }


    public function apply()
    {
        $categorySetup = $this->categorySetupFactory->create(['setup' => $this->moduleDataSetup]);

        $attributes = [
            'category_bottom_category_editorup_new' => [
                'type' => 'text',
                'label' => ' Bottom Category Content',
                'input' => 'textarea',
                'sort_order' => 100,
                'global' => ScopedAttributeInterface::SCOPE_STORE,
                'searchable' => true,
                'comparable' => true,
                'wysiwyg_enabled' => true,
                'is_html_allowed_on_front' => true,
                'visible_in_advanced_search' => true,
                'used_in_product_listing' => true,
                'is_used_in_grid' => true,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
            ]
        ];

        foreach ($attributes as $attributeCode => $attributeOptions) {
            $categorySetup->addAttribute(
                \Magento\Catalog\Model\Category::ENTITY,
                $attributeCode,
                array_merge(
                    [
                        'group' => 'Bottom Category Content',
                        'required' => false,
                        'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                        'visible' => true,
                        'user_defined' => true,
                        'is_wysiwyg_enabled' => true,
                    ],
                    $attributeOptions
                )
            );
        }

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    public static function getDependencies()
    {
        return [
            UpdateMediaAttributesBackendTypes::class,
        ];
    }

    public static function getVersion()
    {
        return '2.0.5';
    }

    public function getAliases()
    {
        return [];
    }
}
