<?php

namespace Banyo\CustomCategory\Setup\Patch\Data;

use Magento\Catalog\Model\Category;
use Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

/**
 * Class AddCustomCategoryAttributes
 *
 * Adds custom attributes to the category entity in Magento, allowing additional
 * fields such as text areas and an image to be assigned to categories for the top tabs. The attributes
 * are grouped under "Custom Category Group" in the backend category management section.
 */
class AddCustomCategoryAttributes implements DataPatchInterface
{
    /**
     * @var EavSetupFactory
     */
    private EavSetupFactory $eavSetupFactory;

    /**
     * @var ModuleDataSetupInterface
     */
    private ModuleDataSetupInterface $moduleDataSetup;

    /**
     * @param EavSetupFactory $eavSetupFactory
     * @param ModuleDataSetupInterface $moduleDataSetup
     */
    public function __construct(
        EavSetupFactory $eavSetupFactory,
        ModuleDataSetupInterface $moduleDataSetup
    ) {
        $this->eavSetupFactory = $eavSetupFactory;
        $this->moduleDataSetup = $moduleDataSetup;
    }

    /**
     * @return void
     * @throws \Magento\Framework\Exception\LocalizedException
     * @throws \Magento\Framework\Validator\ValidateException
     */
    public function apply()
    {
        $this->moduleDataSetup->getConnection()->startSetup();

        $eavSetup = $this->eavSetupFactory->create(['setup' => $this->moduleDataSetup]);

        $attributes = [
            'first_tab' => [
                'type' => 'text',
                'label' => 'First Tab',
                'input' => 'textarea',
                'sort_order' => 100,
            ],
            'second_tab' => [
                'type' => 'text',
                'label' => 'Second Tab',
                'input' => 'textarea',
                'sort_order' => 120,
            ],
            'third_tab' => [
                'type' => 'text',
                'label' => 'Third Tab',
                'input' => 'textarea',
                'sort_order' => 140,
            ],
            'first_content' => [
                'type' => 'text',
                'label' => 'First Content',
                'input' => 'textarea',
                'sort_order' => 110,
                'is_wysiwyg_enabled' => true,
            ],
            'second_content' => [
                'type' => 'text',
                'label' => 'Second Content',
                'input' => 'textarea',
                'sort_order' => 130,
                'is_wysiwyg_enabled' => true,
            ],
            'third_content' => [
                'type' => 'text',
                'label' => 'Third Content',
                'input' => 'textarea',
                'sort_order' => 150,
                'is_wysiwyg_enabled' => true,
            ],
            'tab_image' => [
                'type' => 'varchar',
                'label' => 'Tab Image',
                'input' => 'image',
                'backend' => \Magento\Catalog\Model\Category\Attribute\Backend\Image::class,
                'required' => false,
                'sort_order' => 160
            ],
            'shop_by_category_section_title' => [
                'type' => 'text',
                'label' => 'Shop by Category Section Title',
                'input' => 'textarea',
                'sort_order' => 170,
            ]
        ];

        foreach ($attributes as $attributeCode => $attributeOptions) {
            $eavSetup->addAttribute(
                Category::ENTITY,
                $attributeCode,
                array_merge(
                    [
                        'group' => 'Custom Category Group',
                        'required' => false,
                        'global' => ScopedAttributeInterface::SCOPE_STORE,
                        'visible' => true,
                        'user_defined' => true,
                    ],
                    $attributeOptions
                )
            );
        }

        $this->moduleDataSetup->getConnection()->endSetup();
    }

    /**
     * @return array|string[]
     */
    public static function getDependencies()
    {
        return [];
    }

    /**
     * @return array|string[]
     */
    public function getAliases()
    {
        return [];
    }
}
