<?php
declare(strict_types=1);

namespace Banyo\CustomProduct\Controller\Ajax;

use Magento\Framework\App\Action\Action;
use Magento\Framework\App\Action\Context;
use Magento\Framework\App\RequestInterface;
use Magento\Framework\Controller\ResultFactory;
use Magento\Framework\Session\SessionManagerInterface;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\Mail\Template\TransportBuilder;

class Request extends Action
{
    protected RequestInterface $request;
    protected SessionManagerInterface $session;
    protected StoreManagerInterface $storeManager;
    protected TransportBuilder $transportBuilder;

    public function __construct(
        Context                 $context,
        RequestInterface        $request,
        SessionManagerInterface $session,
        StoreManagerInterface   $storeManager,
        TransportBuilder        $transportBuilder
    ) {
        parent::__construct($context);
        $this->request = $request;
        $this->session = $session;
        $this->storeManager = $storeManager;
        $this->transportBuilder = $transportBuilder;
    }

    public function execute()
    {


        // Get POST data
        $data = $this->request->getPostValue();
        $businessName = $data['company'] ?? 'Business Name';
        $email        = $data['email'] ?? 'test@banyo.co.uk';

        $storeId = $this->storeManager->getStore()->getId();
        $subject = "A new account login request received.";

        $transport = $this->transportBuilder
            ->setTemplateIdentifier(8) // your email template ID
            ->setTemplateOptions([
                'area'  => 'frontend',
                'store' => $storeId,
            ])
            ->setTemplateVars([
                'cust' => [
                    'name'  => $businessName,
                    'email' => $email,
                ],
                'subject' => $subject,
            ])
            ->setFromByScope('general')
            ->addTo('anees.ahmed@nexus-home.com')
            ->getTransport();

        $transport->getMessage()->setSubject($subject);
        $transport->sendMessage();


    }
}
