<?php
declare(strict_types=1);

namespace Banyo\CustomProduct\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\App\RequestInterface;
use Psr\Log\LoggerInterface;

class BrandLogo implements ArgumentInterface
{
    private ResourceConnection $resourceConnection;
    private RequestInterface $request;
    private LoggerInterface $logger;

    public function __construct(
        ResourceConnection $resourceConnection,
        RequestInterface $request,
        LoggerInterface $logger
    ) {
        $this->resourceConnection = $resourceConnection;
        $this->request = $request;
        $this->logger = $logger;
    }

    /**
     * @param string $urlKey
     * @return string|null
     */
    public function getProductPageLogoImageUrl(string $urlKey): ?string
    {
        try {
            $connection = $this->resourceConnection->getConnection();
            $tableName = $this->resourceConnection->getTableName('mst_brand_page');

            $select = $connection->select()
                ->from($tableName, ['brand_product_page_logo'])
                ->where('url_key = ?', $urlKey)
                ->limit(1);

            $logo = $connection->fetchOne($select);

            if ($logo) {
                return '/media/brand/logo/' . ltrim($logo, '/');
            }
        } catch (\Exception $e) {
            $this->logger->error('BrandLogo ViewModel Error: ' . $e->getMessage());
        }

        return null;
    }
}
