<?php
namespace Banyo\CustomProduct\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Review\Block\Product\ReviewRenderer;
use Magento\Catalog\Api\Data\ProductInterface;
use Magento\Framework\View\LayoutInterface;

class ReviewTab implements ArgumentInterface
{
    protected LayoutInterface $layout;

    public function __construct(LayoutInterface $layout)
    {
        $this->layout = $layout;
    }

    protected function getReviewRenderer(): ReviewRenderer
    {
        /** @var ReviewRenderer $renderer */
        $renderer = $this->layout->createBlock(ReviewRenderer::class);
        return $renderer;
    }

    public function getAverageRating(ProductInterface $product): string
    {
        $renderer = $this->getReviewRenderer();
        $renderer->setProduct($product);

        $summary = $renderer->getRatingSummary();
        $stars = $summary / 100 * 5;

        return number_format($stars, 1); // e.g., 4.5
    }

    public function getRatingHtml(ProductInterface $product): string
    {
        $renderer = $this->getReviewRenderer();
        return $renderer->getReviewsSummaryHtml($product, ReviewRenderer::FULL_VIEW, true);
    }

    public function getReviewCount(ProductInterface $product): int
    {
        $renderer = $this->getReviewRenderer();
        $renderer->setProduct($product);
        return (int)$renderer->getReviewsCount();
    }
}
