<?php
declare(strict_types=1);

namespace Banyo\SeoFix\Plugin;

use Mageplaza\Blog\Block\Post\View;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\UrlInterface;

class BlogOgImagePlugin
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    /**
     * Replace the blog post image URL with the store logo
     *
     * @param View $subject
     * @param string $result
     * @return string
     */
    public function afterGetImageUrl(View $subject, $result)
    {
        return $this->storeManager
            ->getStore()
            ->getBaseUrl(UrlInterface::URL_TYPE_MEDIA)
            . 'logo/stores/1/BanyoStoreLogo.png';
    }
}
