<?php
declare(strict_types=1);

namespace Banyo\SeoFix\Plugin;

use Mirasvit\SeoMarkup\Block\Twitter\Card;
use Magento\Store\Model\StoreManagerInterface;
use Magento\Framework\UrlInterface;

class TwitterCardImagePlugin
{
    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        StoreManagerInterface $storeManager
    ) {
        $this->storeManager = $storeManager;
    }

    public function afterGetImage(Card $subject, $result)
    {
        $fullActionCode = $subject->getRequest()->getFullActionName();

        if ($fullActionCode === 'cms_index_index') {
            return $this->storeManager
                    ->getStore()
                    ->getBaseUrl(UrlInterface::URL_TYPE_MEDIA)
                . 'logo/stores/1/BanyoStoreLogo.png';
        }

        return $result;
    }
}
