<?php
/**
 * @category Mageants HyvaSimpleConfigurable
 * @package Mageants_HyvaSimpleConfigurable
 * @copyright Copyright (c) 2023 Mageants
 * @author Mageants Team <info@mageants.com>
 */
namespace Mageants\HyvaSimpleConfigurable\Block\Product\Renderer\Listing;

use Magento\Catalog\Block\Product\Context;
use Magento\Catalog\Helper\Product as CatalogProduct;
use Magento\Catalog\Model\Product;
use Magento\ConfigurableProduct\Helper\Data;
use Magento\ConfigurableProduct\Model\ConfigurableAttributeData;
use Magento\ConfigurableProduct\Model\Product\Type\Configurable\Variations\Prices;
use Magento\Customer\Helper\Session\CurrentCustomer;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Json\EncoderInterface;
use Magento\Framework\Locale\Format;
use Magento\Framework\Pricing\PriceCurrencyInterface;
use Magento\Framework\Stdlib\ArrayUtils;
use Magento\Swatches\Helper\Data as SwatchData;
use Magento\Swatches\Helper\Media;
use Magento\Swatches\Model\SwatchAttributesProvider;
use Magento\Catalog\Api\ProductRepositoryInterface;
use Magento\Framework\View\DesignInterface;
use Mageants\SimpleConfigurable\Block\Product\Renderer\Listing\Configurable as MageantsConfigurable;
use Mageants\SimpleConfigurable\Helper\Data as SimpleConfigurableHelper;

/**
 * Swatch renderer block in Category page
 */
class Configurable extends MageantsConfigurable
{

    /**
     * @var \Magento\Framework\View\DesignInterface
     */
    protected $theme;

    /**
     * Constructor Dependencies
     *
     * @param Context                        $context
     * @param ArrayUtils                     $arrayUtils
     * @param EncoderInterface               $jsonEncoder
     * @param Data                           $helper
     * @param \Magento\Catalog\Model\Product $selectedProduct
     * @param CatalogProduct                 $catalogProduct
     * @param CurrentCustomer                $currentCustomer
     * @param PriceCurrencyInterface         $priceCurrency
     * @param ConfigurableAttributeData      $configurableAttributeData
     * @param SwatchData                     $swatchHelper
     * @param Media                          $swatchMediaHelper
     * @param ProductRepositoryInterface     $productRepositoryInterface
     * @param DesignInterface                $theme
     * @param SimpleConfigurableHelper       $simpleConfigurableHelper
     * @param array                          $data
     * @param SwatchAttributesProvider|null  $swatchAttributesProvider
     * @param Format|null                    $localeFormat
     * @param Prices|null                    $variationPrices
     */
    public function __construct(
        Context $context,
        ArrayUtils $arrayUtils,
        EncoderInterface $jsonEncoder,
        Data $helper,
        \Magento\Catalog\Model\Product $selectedProduct,
        CatalogProduct $catalogProduct,
        CurrentCustomer $currentCustomer,
        PriceCurrencyInterface $priceCurrency,
        ConfigurableAttributeData $configurableAttributeData,
        SwatchData $swatchHelper,
        Media $swatchMediaHelper,
        ProductRepositoryInterface $productRepositoryInterface,
        DesignInterface $theme,
        SimpleConfigurableHelper $simpleConfigurableHelper,
        array $data = [],
        ?SwatchAttributesProvider $swatchAttributesProvider = null,
        ?Format $localeFormat = null,
        ?Prices $variationPrices = null
    ) {
        parent::__construct(
            $context,
            $arrayUtils,
            $jsonEncoder,
            $helper,
            $selectedProduct,
            $catalogProduct,
            $currentCustomer,
            $priceCurrency,
            $configurableAttributeData,
            $swatchHelper,
            $swatchMediaHelper,
            $simpleConfigurableHelper,
            $data,
            $swatchAttributesProvider,
            $localeFormat,
            $variationPrices
        );
        $this->theme = $theme;
    }

    /**
     * Template
     *
     * @return string
     */
    protected function getRendererTemplate()
    {
        if (!$this->isHyva()) {
            $this->_template = 'Mageants_SimpleConfigurable::product/listing/renderer.phtml';

        } else {

            $this->_template = 'Mageants_HyvaSimpleConfigurable::product/listing/renderer.phtml';
        }
        
        return $this->_template;
    }

     /**
      * Returns true if the current theme is a Hyva theme, a descendant of Hyva/reset (or any Hyva namespaced theme)
      *
      * @return bool
      */
    public function isHyva(): bool
    {
        $theme = $this->theme->getDesignTheme();
        while ($theme) {
            if (strpos($theme->getCode(), 'Hyva/') === 0) {
                return true;
            }
            $theme = $theme->getParentTheme();
        }
        return false;
    }
}
