<?php

namespace Nexus\AdminPaypalMethod\Plugin;

/**
 * Class PreSelect
 *
 * @package Bss\AdminPaymentMethod\Plugin
 */

class PreSelect
{
    /**
     * @var \Bss\AdminPaymentMethod\Model\AdminPaymentMethod
     */
    private $model;

    /**
     * PreSelect constructor.
     * @param \Bss\AdminPaymentMethod\Model\AdminPaymentMethod $model
     */
    public function __construct(\Nexus\AdminPaypalMethod\Model\AdminPaypalMethod $model)
    {
        $this->model = $model;
    }

    /**
     * @param \Magento\Sales\Block\Adminhtml\Order\Create\Billing\Method\Form $block
     * @param $result
     * @return bool|string
     * @SuppressWarnings(PHPMD.UnusedFormalParameter)
     */
    public function afterGetSelectedMethodCode(
        \Magento\Sales\Block\Adminhtml\Order\Create\Billing\Method\Form $block,
        $result
    ) {
        if ($result && $result != 'free') {
            return $result;
        }

        $data = $this->model->getDataPreSelect();
        if ($data) {
            $result = \Nexus\AdminPaypalMethod\Model\AdminPaypalMethod::CODE;
            return $result;
        }
        return false;
    }
}
