<?php  
namespace Nexus\Catalog\Block\Adminhtml\Category\Tab;
 
use Magento\Framework\DataObject;
use Magento\Framework\App\Filesystem\DirectoryList;
 
class ProductImage extends \Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer
{
    /**
     * @var \Magento\Catalog\Model\CategoryFactory
     */
    protected $categoryFactory;

    protected $_filesystem;
    /**
     * @param \Magento\Catalog\Model\CategoryFactory $categoryFactory
     */
    public function __construct(
        \Magento\Catalog\Model\ProductFactory $productFactory,
         \Magento\Framework\Filesystem $filesystem,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->_productFactory = $productFactory;
        $this->_filesystem = $filesystem;
        $this->_storeManager = $storeManager;
    }
 
    /**
     * get category name
     * @param  DataObject $row
     * @return string
     */
    public function render(DataObject $row)
    {
        $entity_id = $row->getId();
        $product = $this->_productFactory->create()->load($entity_id);
        $media = $this->_storeManager->getStore(1)->getBaseUrl();
        $mediapath = $this->_filesystem->getDirectoryRead(DirectoryList::MEDIA)->getAbsolutePath();
        $url = $media."media/catalog/product".$product->getThumbnail(); 
        $out = "<b>No Image</b>"; 
        if(null !== $product->getThumbnail() && file_exists($mediapath."catalog/product".$product->getThumbnail())){     
            $out = "<img src=". $url ." width='60px'/>";
        }
        return $out;
    }
}