<?php  
namespace Nexus\Catalog\Block\Adminhtml\Category\Tab;
 
use Magento\Framework\DataObject;
use Magento\CatalogInventory\Model\StockRegistry; 
class ProductStock extends \Magento\Backend\Block\Widget\Grid\Column\Renderer\AbstractRenderer
{
    
    protected $stockItemRepository;
   
    public function __construct(
        StockRegistry $stockRegistry,
        \Magento\Store\Model\StoreManagerInterface $storeManager
    ) {
        $this->stockRegistry = $stockRegistry;
        $this->_storeManager = $storeManager;
    }
 
    public function render(DataObject $row)
    {
        $sku = $row->getSku();
        
        $stockStatus = 'Out of Stock';
        try {
            $stockStatus = $this->stockRegistry->getStockStatusBySku(
                $sku,
                $this->_storeManager->getWebsite()->getId()
            );
            $stockData = $stockStatus->getStockItem();
            $stockStatus = $stockData->getIsInStock();
            if($stockStatus){
                $stockStatus = 'In Stock';
            }else{
                $stockStatus = 'Out of Stock'; 
            }
        } catch (\Exception $exception) {
            $this->logger->error($exception->getMessage());
            $stockStatus = 'Out of Stock';
        }
        return  $stockStatus;
        
        
    }
}