<?php
namespace Nexus\Catalog\Block\Adminhtml\Productlink\Import\Edit;
class Form extends \Magento\Backend\Block\Widget\Form\Generic
{
    /**
     * Customer Service.
     *
     * @var CustomerAccountServiceInterface
     */
    protected $_customerAccountService;
     /**
     * @var \Magento\Store\Model\System\Store
     */
    protected $_systemStore;
    
    protected $_years;
    /**
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Framework\Registry $registry
     * @param \Magento\Framework\Data\FormFactory $formFactory
     * @param \Magento\Store\Model\System\Store $systemStore
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Framework\Registry $registry,
        \Magento\Framework\Data\FormFactory $formFactory,
        \Magento\Store\Model\System\Store $systemStore,
        array $data = array()
    ) {
		
        $this->_systemStore = $systemStore;
        parent::__construct($context, $registry, $formFactory, $data);
    }

    protected function _prepareForm()
    {
        /** @var \Magento\Framework\Data\Form $form */
        $form = $this->_formFactory->create(
            array(
                'data' => array(
                    'id' => 'edit_form',
                    'action' => $this->getUrl('*/*/importlists'),
                    'method' => 'post',
                    'enctype' => 'multipart/form-data'
                )
            )
        );
        $form->setUseContainer(true);
		
        $form->setHtmlIdPrefix('page_');

        $fieldset = $form->addFieldset('base_fieldset', array('legend' => __('Import Upsell or Crosssell Products')));
        

		
		$fieldset->addField(
            'Select month',
            'file',
            array(
                'name' => 'file',
                'label' => __('Upload csv'),
                'title' => __('Upload csv'),
                'required' => true,
                'note'=>"Values for link_type_id<br/> <b>1</b> is for <b>Related</b><br/> <b>4</b> is for <b>Upsell</b> and <b>5</b> is for <b>Crosssell</b>.<br/>Download a <a href='".$this->getUrl('*/*/samplefile')."'>sample file</a>."
                               
            )
        );
        
        
        
		/*{{CedAddFormField}}*/
        $this->setForm($form);
        return parent::_prepareForm();
    }
}
