<?php


declare(strict_types=1);

namespace Nexus\Catalog\Block\Product\View\Options\Type\Select;

use Magento\Catalog\Api\Data\ProductCustomOptionValuesInterface;
use Magento\Catalog\Block\Product\View\Options\AbstractOptions;
use Magento\Catalog\Model\Product\Option;

/**
 * Represent needed logic for checkbox and radio button option types
 */
class Checkable extends \Magento\Catalog\Block\Product\View\Options\Type\Select\Checkable
{
    
    public function getCurrencyByStore(ProductCustomOptionValuesInterface $_value)
    {
        /** @noinspection PhpMethodParametersCountMismatchInspection */

        if(null !== $_value->getData('special_price')){
        	 $mageworx_price = json_decode($_value->getData('special_price'),true);
             return   $cprice=number_format($mageworx_price[0]['price']+(($mageworx_price[0]['price']*20)/100),2,'.','');
        }else{
             return   $cprice=number_format($_value->getPrice(true)+(($_value->getPrice(true)*20)/100),2,'.','');
        }
          
    }

    
}
