<?php

namespace Nexus\Catalog\Controller\Adminhtml\Categoryimport;

class Samplefile extends \Magento\Backend\App\Action
{
    /**
     * Page result factory
     * 
     * @var \Magento\Framework\View\Result\PageFactory
     */
    protected $_resultPageFactory;

    /**
     * Page factory
     * 
     * @var \Magento\Backend\Model\View\Result\Page
     */
    protected $_resultPage;

    /**
     * File downloader instance
     * 
     * @var \Magento\Framework\App\Response\Http\FileFactory
     */
    protected $_downloader;

    /**
     * Directory list instance
     * 
     * @var \Magento\Framework\Filesystem\DirectoryList
     */
    protected $directory;

    /**
     * Constructor
     * 
     * @param \Magento\Framework\View\Result\PageFactory $resultPageFactory
     * @param \Magento\Backend\App\Action\Context $context
     * @param \Magento\Framework\App\Response\Http\FileFactory $fileFactory
     * @param \Magento\Framework\Filesystem\DirectoryList $directory
     */
    public function __construct(
        \Magento\Framework\View\Result\PageFactory $resultPageFactory,
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\App\Response\Http\FileFactory $fileFactory,
        \Magento\Framework\Filesystem\DirectoryList $directory
    )
    {
        $this->_resultPageFactory = $resultPageFactory;
        $this->_downloader =  $fileFactory;
        $this->directory = $directory;
        parent::__construct($context);
    }

    /**
     * Execute the action
     *
     * @return \Magento\Backend\Model\View\Result\Page|\Magento\Framework\View\Result\Page
     */
    public function execute()
    {
        // Define the file path
        $file = dirname(__FILE__)."/Files/positions.csv";

        // Create and return the file download response
        return $this->_downloader->create(
            "Products_in_Category.csv",  // The name of the file to be downloaded
            @file_get_contents($file),   // Contents of the file
            \Magento\Framework\App\Filesystem\DirectoryList::TMP  // The directory type for temporary files
        );
    }
}
