<?php
/**
 * Copyright © Magento, Inc. All rights reserved.
 * See COPYING.txt for license details.
 */
namespace Nexus\Sales\Ui\Component\Listing\Column;

use Magento\Framework\Escaper;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Sales\Model\ResourceModel\Order\Status\CollectionFactory;

/**
 * Class Address
 */
class ProductName extends Column
{
    /**
     * @var Escaper
     */
    protected $escaper;

    /**
     * @param ContextInterface $context
     * @param UiComponentFactory $uiComponentFactory
     * @param Escaper $escaper
     * @param array $components
     * @param array $data
     */
    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        Escaper $escaper,
        \Magento\Framework\View\LayoutFactory $layoutFactory,
        array $components = [],
        array $data = []
    ) {
        $this->escaper = $escaper;
        $this->layoutFactory = $layoutFactory;
        parent::__construct($context, $uiComponentFactory, $components, $data);
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return array
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $options = json_decode($item['product_options'],true);
                $block = $this->layoutFactory->create()->createBlock('Magento\Sales\Block\Adminhtml\Items\Column\Name');
                $html = '<b>'.$item['name']."</b><br/>";
                if(array_key_exists('options',$options)){
                foreach ($options['options'] as $_option) { 
                    $html .= '<dt><b>'.$block->escapeHtml($_option['label']).':</b></dt>';
                    $html .= '<dd>';?>
                        <?php if (isset($_option['custom_view']) && $_option['custom_view']) : 
                            $html .= $block->getCustomizedOptionValue($_option) ;
                         else : ?>
                                <?php $_option = $block->getFormattedOption($_option['value']); ?>
                                <?php $dots = 'dots' . uniqid(); ?>
                                <?php $id = 'id' . uniqid(); ?>
                                <?php $html .= $block->escapeHtml($_option['value'], ['a', 'br']) ?><?php if (isset($_option['remainder']) && $_option['remainder']) : 

                                     $html .='<span id="'.$dots.'"> ...</span><span id="'.$id.'">'.$block->escapeHtml($_option['remainder'], ['a']).'</span>';
                                    $html .="<script>
                                        require(['prototype'], function() {
                                            $('".$id."').hide();
                                            $('".$id."').up().observe('mouseover', function(){ $('".$id."').show();});
                                            $('".$id."').up().observe('mouseover', function(){ $('".$id."').hide();});
                                            $('".$id."').up().observe('mouseout',  function(){ $('".$id."').hide();});
                                            $('".$id."').up().observe('mouseout',  function(){ $('".$id."').show();});
                                        });
                                    </script>";
                                   endif; ?>
                            <?php endif; ?>
                        <?php $html .="</dd>";?>
                <?php 
                }
               }
                $item[$this->getData('name')] = $html;
            }
        }

        return $dataSource;
    }
}
