const {
    spacing
} = require('tailwindcss/defaultTheme');

const colors = require('tailwindcss/colors');

const hyvaModules = require('@hyva-themes/hyva-modules');

module.exports = hyvaModules.mergeTailwindConfig({
    theme: {
        extend: {
            width: {
                '30p': '32%',
            },
            screens: {
                'xs': '375px',
                // => @media (min-width: 640px) { ... } 'sm': '640px',
                // => @media (min-width: 640px) { ... }
                'md': '768px',
                // => @media (min-width: 768px) { ... }
                'lg': '1024px',
                // => @media (min-width: 1024px) { ... }
                'xl': '1280px',
                // => @media (min-width: 1280px) { ... }
                '2xl': '1536px', // => @media (min-width: 1536px) { ... }
                // => @media (min-width: 1280px) { ... }
                '3xl': '1920px' // => @media (min-width: 1536px) { ... }
            },
            boxShadow: {
                'banyo-shadow': `0px 0px 4px rgba(0, 0, 0, 0.00),
                       0px 0px 4px rgba(0, 0, 0, 0.01),
                       0px 0px 3px rgba(0, 0, 0, 0.05),
                       0px 0px 3px rgba(0, 0, 0, 0.09),
                       0px 0px 1px rgba(0, 0, 0, 0.10)`
            },
            fontFamily: {
                /**
                 * @see app/design/frontend/Banyo/NexusTheme/web/tailwindcomponents/typography.css
                 */
                inter: ["Montserrat", "sans-serif"],
                sen: ["Sen", "Helvetica Neue", "Arial", "sans-serif"] // for headings
            },
            colors: {
                primary: {
                    '50': "#D3EDFF",
                    '100': "#a7dbff",
                    '200': "#ff9d40",
                    "DEFAULT": "#ED6C02",
                    "banyo" : "#ED6C02"
                },
                secondary: {
                    '500' : "#2B3445",
                    "DEFAULT": "#36363A"

                },
                white: {
                    "DEFAULT": "#FFFFFF",
                    '500': "#FAFAFA",
                    '600': "#F5F5F5",
                },
                green: {
                    "DEFAULT": "#22C55E"
                },
                red: {
                    "DEFAULT": "#B3261E"
                },
                yellow: {
                    "DEFAULT": "#F6C657"
                },
                lightseagreen: {
                    "400": "#11B1A7",
                    "DEFAULT": "#F0FDF4"
                },
                black: {
                    "50" : "#C0C0C0",
                    "300": "#5A5A5A",
                    "350": "#333333",
                    "400": "#111111",
                    "DEFAULT": "#000000"
                },
                platinumgray: {
                    "DEFAULT": "#797979",
                    '500': "#818181"
                },
                magenta: {
                    'DEFAULT': '#FF00FF',
                    '100': '#D9C6D5'
                },
                nickel: {
                    'DEFAULT': '#737373'
                },
                grey: {
                    '100': '#475257' ,
                    'DEFAULT': '#EAE7E7'

                }
            },
            textColor: {
                orange: colors.orange,
                red: {
                    "DEFAULT": "#b3261e"
                },
                primary: {
                    '50': "#D3EDFF",
                    '100': "#a7dbff",
                    '200': "#ff9d40",
                    "DEFAULT": "#ED6C02",
                    "banyo" : "#ED6C02"
                },
                secondary: {
                    '500' : "#2B3445",
                    "DEFAULT": "#36363A"

                },
            },
            backgroundColor: {
                primary: {
                    '50': "#D3EDFF",
                    '100': "#a7dbff",
                    '200': "#ff9d40",
                    "DEFAULT": "#ED6C02",
                    "banyo" : "#ED6C02"
                },
                secondary: {
                    '500' : "#2B3445",
                    "DEFAULT": "#36363A"

                },
                yellow: {
                    "DEFAULT": "#F6C657"
                },
                red: {
                    "DEFAULT": "#B3261E"
                },
                maroon: {
                    "DEFAULT": "#6A2C29"
                },
                header: {
                    darker: "#E0E9F4"
                },
                container: {
                    lighter: colors.white,
                    "DEFAULT": colors.neutral['50'],
                    darker: colors.neutral['100'],
                    screens: {
                        sm: '100%',   // for small screens
                        md: '728px',  // medium screens
                        lg: '1024px', // large screens
                        xl: '1200px', // extra large
                        '2xl': '1440px', // extra-extra large
                        '3xl' : '1536px' //for large desktop
                    }
                }
            },
            borderColor: {
                primary: {
                    'lighter': "#D3EDFF",
                    '100': "#a7dbff",
                    '200': "#ff9d40",
                    "DEFAULT": "#ED6C02",
                    "darker" : "#ED6C02"
                },
                secondary: {
                    'lighter' : "#2B3445",
                    "DEFAULT": "#36363A",
                    "darker": "#36363A"

                },
                container: {
                    lighter: colors.neutral['100'],
                    "DEFAULT": '#e7e7e7',
                    darker: '#b6b6b6'
                }
            },
            minHeight: {
                a11y: spacing["11"],
                'screen-25': '25vh',
                'screen-50': '50vh',
                'screen-75': '75vh'
            },
            maxHeight: {
                'screen-25': '25vh',
                'screen-50': '50vh',
                'screen-75': '75vh'
            },
            container: {
                center: true,
                padding: spacing["6"]
            },
        }, safelist: [
            'group-hover:block',
            'group-hover:hidden',
            'block',
            'hidden',
            'absolute',
            'top-0',
            'left-0',
            'relative',
            'w-[51px]',
            'h-[51px]'
        ],
    },
    plugins: [require('@tailwindcss/forms'), require('@tailwindcss/typography')],
    // Examples for excluding patterns from purge
    content: [
        // this theme's phtml and layout XML files
        '../../**/*.phtml',
        //'../../*/layout/*.xml',
        // parent theme in Vendor (if this is a child-theme)
        '../../../../../../../vendor/hyva-themes/magento2-default-theme/**/*.phtml',
        // app/code phtml files (if need tailwind classes from app/code modules)
        // '../../../../../../../app/code/**/*.phtml'
    ]
});
